/************************************************************************
 * NAME:	logio.c()
 *
 * DESCR:	Logical IO routines.  Simple puts the sector mapping
 *		on top of the "pysical" sectors.  It should be noted,
 *		however, that the physical sectors end-up being mapped
 *		trough the low-level floppy.c logical sectors.  These
 *		logical sectors refer to the way in which the sectors
 *		are layed out on the disk.
 *
 * NOTES:	- the DOS33_ORDER[] array is the inverse of that found
 *		  in ../apple.c.
 ************************************************************************/
#include "ados.h"
#include "standard.h"

static int DOS33_ORDER[] = { 0, 13, 11, 9, 7, 5, 3, 1, 14, 12, 10, 8, 6, 4, 2, 15 };

/************************************************************************
 * NAME:	ados_putlsect()
 *
 * DESCR:	Write logical sector to floppy disk file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:	- the static check for a sector between 0 and 15 should
 *		  really take into account the number of sectors in
 *		  ados->vtoc->sectors...but since the DOS33_ORDER array
 *		  is statically from 0 to 15, it makes more sense to use that.
 ************************************************************************/
int
ados_putlsect(struct adosfs *adosfs, int track, int sect, char buf[])
{
    if (sect < 0 || sect > 15) {	/* see note above	*/
	return(FALSE);
    }

    switch(adosfs->type) {
        case DOS33:
	    sect = DOS33_ORDER[sect];
	    break;

        case DOS32:
        case PRODOS:
	    break;
    }

    return(ados_putpsect(adosfs,track,sect+adosfs->startsec,buf));
}

/************************************************************************
 * NAME:	ados_getlsect()
 *
 * DESCR:	Read logical sector from floppy disk file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:	- the static check for a sector between 0 and 15 should
 *		  really take into account the number of sectors in
 *		  ados->vtoc->sectors...but since the DOS33_ORDER array
 *		  is statically from 0 to 15, it makes more sense to use that.
 ************************************************************************/
int
ados_getlsect(struct adosfs *adosfs, int track, int sect, char buf[])
{
    if (sect < 0 || sect > 15) {	/* see note above	*/
	return(FALSE);
    }

    switch(adosfs->type) {
        case DOS33:
	    sect = DOS33_ORDER[sect];
	    break;

        case DOS32:
        case PRODOS:
	    break;
    }

    return(ados_getpsect(adosfs,track,sect+adosfs->startsec,buf));
}
